
// MP2EncoderDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CMP2EncoderDlg dialog
class CMP2EncoderDlg : public CDialogEx
{
// Construction
public:
	CMP2EncoderDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMP2EncoderDlg)
	enum { IDD = IDD_MP2ENCODER_DIALOG };
	CStatic			m_statWindow;
	CButton		m_btnStart;
	CButton		m_btnStop;
	//}}AFX_DATA

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnBnClickedBtnStart();
	afx_msg void OnBnClickedBtnStop();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	CString				GetWorkingPath( );

public:

	DEVICE_HANDLE				m_hVideoDev;										// VIDEO STREAM CAPTURE DEVICE	

	DEVICE_HANDLE				m_hAudioDev;										// AUDIO STREAM CAPTURE DEVICE 

	DEVICE_HANDLE				m_hAudioMP2EncoderDev;					// AUDIO MP2 SOFTWARE ENCODER DEVICE 

	ULONG								m_nFileRendererRecordState;					// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	CRITICAL_SECTION			m_hAccessFileCriticalSection;					// FILE ACCESS CRITICAL SECTION

	BOOL									m_bSetBuffer;

	HANDLE 							m_hAudioThreadBufferReadyEvent;

	HANDLE								m_hAudioThread;

	ULONG								m_hAudioThreadNumber;
	
	CStdioFile *							m_pTxtFile;

	CStdioFile *							m_pBinFile;		
};
